Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[jungle.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[T_Normal.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 0.0,
	},
	Rules = 
	{
		AutoCapture 	= false,	    --Destroying hives automatically counts as a capture
		NoPushback		= false,	    --Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = false,        --Do captures halve defensive strength?
		DisableLockdown = false,        --Turn off emergency help is player is behind
		SmartMutations	= true
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		Default = [[inactive]],
		FreeUpgradesDefault = [[active]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnDebugCall = function (mousePos)

		capturesWanted = capturesWanted + 1
		AssaultTimer:Enable()
--[[
		local mutationCount = #MutationWatcher.mutationList
		for i=1, mutationCount do
            GameWorld:DeactivateMutation(MutationWatcher.mutationList[i], false)
        end
        MutationWatcher.mutationList = {}
     
        for i=1, mutationCount do
            GameWorld:ApplyNextMutation(true)
        end
      
 --]]
 
	end
}

capturesWanted = 0
AssaultTimer = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetEventIndicator("Test Timer On")
	end,
	
	{[[NT_ENTITY_ASSAULT_COMMAND]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		CreateDebugTimer()
	
		self:Disable()
	end)


function CreateDebugTimer()

    local stopTimer
	local timerCount = 0
	local function LevelTimerUpdate(p_milliseconds)
		
		if stopTimer then
		    return
		end

        timerCount = timerCount + p_milliseconds
		
		GameWorld:SetEventIndicator(string.format("%d:%02d", timerCount / 60000, (timerCount % 60000) / 1000))
	end
	ScriptMgr:SetUpdateCallback(LevelTimerUpdate)

    local captureTrigger
	captureTrigger = LevelUtils.MakeGoal(
		function (self)
		end,
		
		{[[NT_POINT_CAPTURED]]},
		function (self, p_type, p_entId, p_pos, p_other)	
			capturesWanted = capturesWanted - 1
			
			if capturesWanted <= 0 then
				stopTimer = true
			
				self:Disable()
			end
		end)
	captureTrigger:Enable()	
end


------------------------------------------------------------------------------- Mutation has happened!
MutationWatcher = LevelUtils.MakeGoal(
	function (self)
		MutationWatcher.mutationList = {}
	end,
	
	{[[NT_MUTATION_EVOLVED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        table.insert(self.mutationList, p_other)
		
	end)
MutationWatcher:Enable()
